## Inheritance recipients aged 30–89 in the top third of the wealth distribution for their age group save 40 per cent 
## of their received inheritance in other assets upon receipt, the middle third saves 20 per cent,
## and the bottom third saves 5 per cent.


## This will be merged in to replace bequest saving rates during model run
bequest_saving_rate <- data.table(
  beqrec = -1,
  prev_age_wlth_grp3 = c(0, 1, 2, 3),
  bequest_other_asset_saving_grp3_param = c(0.2, 0.05, 0.2, 0.4)
)

## Note age_wlth_grp3=0 is for age groups <30 or >90 - where bequest distributed evenly
## There will be v few people getting a bequest at these ages. Assumed they have same saving rate as mid group


## save it
qsave(bequest_saving_rate, "./Input data/bequest_other_asset_saving_grp3.qs")
